print("[*] base64 package __init__.py loaded!")

from .base64 import *  # 先加载你伪造的 base64.py（会弹窗）

# 正确导入真正的 base64.py 文件
import importlib.util
import sys
import os

# 获取真正标准库 base64.py 的路径
real_base64_path = os.path.join(sys.base_prefix, "Lib", "base64.py")

# 使用 importlib 手动加载真正的 base64 模块
spec = importlib.util.spec_from_file_location("real_base64", real_base64_path)
real_base64_module = importlib.util.module_from_spec(spec)
spec.loader.exec_module(real_base64_module)

# 拦截函数：替换 b64encode
def b64encode(data):
    print("[*] Intercepted b64encode in package!")
    return real_base64_module.b64encode(data)

# 覆盖当前模块的 b64encode
sys.modules[__name__].b64encode = b64encode
